% Section 7.72 Tutorial Example1, Case 2: Non-differentiable Fault
% 29/02/2020, Jianglin Lan
close all
clear
clc

% DC motor system
R0 = 1.2; L0 = 0.05; Kv = 0.6; Km = 0.6; J0 = 0.1352; B0 = 0.3;

A = [-B0/J0 Km/J0; -Kv/L0 -R0/L0]; 
B = [0; 1/L0]; 
F = B; 
D1 = [0.1;0.1]; 
C = eye(2); 
D2 = [1;0];


% Define global variables to store data
% Method1: Nominal Design
global Intn_u Intn_ts Intn_count Intn_tmp
Intn_u = []; Intn_ts = []; Intn_count = 0; Intn_tmp = 0;

% Method2: Separated FE and FTC Design
global Ints_u Ints_yy2 Ints_ts Ints_count Ints_tmp Ints_hatfa  Ints_hatd
Ints_u = []; Ints_yy2 = []; Ints_ts = []; Ints_count = 0; Ints_tmp = 0; Ints_hatfa = []; Ints_hatd = [];

% Method3: Simultaneous FE and FTC
global Int_ffa Int_ffs Int_u Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_hatd 
Int_ffa = []; Int_ffs = []; Int_u = []; Int_yy2 = []; Int_ts = []; Int_count = 0; Int_tmp = 0; Int_hatfa = []; Int_hatd = [];

% Method4: Proposed adaptive decoupling FE and FTC
global Intd_u Intd_yy2 Intd_ts Intd_count Intd_tmp Intd_hatfa  Intd_ffa Intd_hatd Intd_uu
Intd_u = []; Intd_yy2 = []; Intd_ts = []; Intd_count=0; Intd_tmp=0; Intd_hatfa=[];  Intd_ffa=[]; Intd_hatd=[]; Intd_uu=0;

% Simulation time
t0 = 0;
tf = 5;
tspan = [t0,tf];

% Initial conditon
z0 = [0;0;0;0];
x0 = [0;0];
xx0 = [z0',x0'];


% Observer & controller design and closed-loop simulation
% Method1: Nominal Design
Kx_nom = Nominal_controller(A,B,D1)
[H_nom,G_nom,M_nom,L_nom] = Nominal_observer(A,F,D1,C,D2)

[Intn_tt,Intn_yy] = ode45(@(t,xx) Nominal_closed_sys_performance(t,xx,A,B,F,D1,C,D2,Kx_nom,H_nom,G_nom,M_nom,L_nom), tspan, xx0);
Intn_x1 = Intn_yy(:,5);
Intn_x2 = Intn_yy(:,6);

% Method2: Separated FE and FTC Design
[Kx_sep,Kf_sep] = Separated_controller(A,B,F,D1)
[H_sep,G_sep,M_sep,L_sep] = Separated_observer(A,F,D1,C,D2)

[Ints_tt,Ints_yy] = ode45(@(t,xx) Separated_closed_sys_performance(t,xx,A,B,F,D1,C,D2,Kx_sep,Kf_sep,H_sep,G_sep,M_sep,L_sep), tspan, xx0);
Ints_x1 = Ints_yy(:,5);
Ints_x2 = Ints_yy(:,6);

% Method3: Simultaneous FE and FTC
[Kx_sim,Kf_sim,H_sim,G_sim,M_sim,L_sim] = Simultaneous_observer_controller(A,B,F,D1,C,D2)
[Int_tt,Int_yy] = ode45(@(t,xx) Simultaneous_closed_sys_performance(t,xx,A,B,F,D1,C,D2,Kx_sim,Kf_sim,H_sim,G_sim,M_sim,L_sim), tspan, xx0);
Int_x1 = Int_yy(:,5);
Int_x2 = Int_yy(:,6);

% Method4: Proposed adaptive decoupling FE and FTC
[P_dec,N_dec,J_dec,L_dec,H_dec,Q_dec] = Decoupling_observer(A,B,F,D1,C,D2)

z10 = zeros(3,1);
veq0 = zeros(1,1);
hat_rho0 = 0;
hat_rho120 = zeros(2,1);
xx10 = [z10', veq0', hat_rho0', x0', hat_rho120'];
[Intd_tt,Intd_yy] = ode45(@(t,xx) Decoupling_closed_sys_performance(t,xx,A,B,F,D1,C,D2,P_dec,N_dec,J_dec,L_dec,H_dec,Q_dec), tspan, xx10);
Intd_x1 = Intd_yy(:,6);
Intd_x2 = Intd_yy(:,7);


% Draw figures
run('Draw_figure.m');